import torch
import torch.nn as nn
import torch.nn.functional as F

class MLP(nn.Module):
    def __init__(self, n_features, n_hidden, n_classes, dropout):
        super(MLP, self).__init__()
        
        self.model = nn.Sequential(
            nn.Linear(n_features, n_hidden),
            nn.BatchNorm1d(n_hidden),
            nn.ReLU(inplace=True),
            nn.Dropout(dropout),
            nn.Linear(n_hidden, n_classes),
        )
    
    def forward(self, x):
        return self.model(x)
